﻿using System;
using System.Text.RegularExpressions;

namespace RegExExamples
{
	class Extractor
	{



		private static string intervalPattern = @"\[(?<lowerBound>\d+);(?<upperBound>\d+)\]";

		public static void ExtractTheBounds(string userInput)
		{
			Match intervalElements = Regex.Match( userInput, intervalPattern);

			if (!intervalElements.Success) System.Console.WriteLine("Invalid input.");

			if (intervalElements.Groups["lowerBound"].Captures.Count == 1)
			{
				int lower = Int32.Parse(intervalElements.Groups["lowerBound"].Value);
				int upper = Int32.Parse( intervalElements.Groups["upperBound"].Value );

				if (lower > upper)
					System.Console.WriteLine(String.Format("Lower bound {0} must be greater than or equal to upper bound {1}.",lower,upper));
				else
					System.Console.WriteLine( "Valid interval." );
			}
		}



		//static void Main( string[] args )
		//{
		//    while (true)
		//    {
		//        ExtractTheBounds( System.Console.ReadLine() );
		//    }
		//}
	}
}
