﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Text;

namespace ObserverKomponente
{
    public partial class SubjektObserver : Component
    {

        /// <summary>
        /// Singleton Liste aller SubjektObserver
        /// </summary>
        private static IList<SubjektObserver> observerList = new List<SubjektObserver>();

        #region Event SubjektAktualisiert

        /// <summary>
        /// Nicht statisches Event für den Designer
        /// </summary>
        public event EventHandler<SubjektEventArgs> 
            SubjektAktualisiert;

        /// <summary>
        /// Static damit auf eine Statische Liste zugegriffen wird
        /// und so die Subjekte Events direkt auf dem Observer
        /// auslösen können.
        /// </summary>
        public static void RaiseSubjektAktualisiert
            (object sender, ISubjekt subjekt)
        {
            foreach (SubjektObserver aObserver in observerList)
            {
                if (aObserver.SubjektAktualisiert == null) continue;
                aObserver.SubjektAktualisiert.Invoke(sender, new SubjektEventArgs(subjekt));
            }
        }

        #endregion

        public SubjektObserver()
        {
            InitializeComponent();

            // Observer der Liste hinzufügen
            observerList.Add(this);
        }

        public SubjektObserver(IContainer container)
        {
            container.Add(this);

            InitializeComponent();

            // Observer der Liste hinzufügen
            observerList.Add(this);
        }

    }
}
