﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ObserverKlassisch
{
    public class Subjekt
    {
        #region Subjekt

        Haarfarbe _haarfarbe;
        DateTime _gebDatum;
        string _name;

        public Haarfarbe Haarfarbe
        {
            get { return _haarfarbe; }
            set
            {
                _haarfarbe = value;
                Benachrichtige();
            }
        }

        public DateTime GebDatum
        {
            get { return _gebDatum; }
            set
            {
                _gebDatum = value;
                Benachrichtige();
            }
        }

        public string Name
        {
            get { return _name; }
            set
            {
                _name = value;
                Benachrichtige();
            }
        }

        #endregion

        #region Attach / Detach

        private void Benachrichtige()
        {
            foreach (IBeobachter beobachter in _beobachter)
            {
                beobachter.Aktualisiere(this);
            }
        }

        private IList<IBeobachter> _beobachter = 
            new List<IBeobachter>();

        public void Registriere(IBeobachter beobachter)
        {
            if (_beobachter.Contains(beobachter)) return;
            _beobachter.Add(beobachter);
        }

        public void Entferne(IBeobachter beobachter)
        {
            if (_beobachter.Contains(beobachter))
                _beobachter.Remove(beobachter);
        }

        #endregion
    }
}
