﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace ObserverKlassisch
{
    public partial class EigenschaftenBeobachter :
        UserControl, IBeobachter
    {
        public EigenschaftenBeobachter()
        {
            InitializeComponent();
        }

        private Subjekt _subjekt;
        public Subjekt Subjekt
        {
            set
            {
                if (_subjekt != null) _subjekt.Entferne(this);
                _subjekt = value;
                Aktualisiere(value);
                if (_subjekt != null) _subjekt.Registriere(this);
            }
        }

        #region IBeobachter Member

        public void Aktualisiere(Subjekt subjekt)
        {
            this.SubjektBindingSource.DataSource = subjekt;
            this.SubjektBindingSource.ResetBindings(false);
        }

        #endregion
    }
}
