﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace ObserverKlassisch
{
    public partial class DatumBeobachter :
        UserControl, IBeobachter
    {
        public DatumBeobachter()
        {
            InitializeComponent();
        }

        private Subjekt _subjekt;
        public Subjekt Subjekt
        {
            set
            {
                if (_subjekt != null) _subjekt.Entferne(this);
                _subjekt = value;
                Aktualisiere(value);
                if (_subjekt != null) _subjekt.Registriere(this);
            }
        }

        private void monthCalendar_DateChanged(object sender, DateRangeEventArgs e)
        {
            if (this._subjekt == null) return;
            this._subjekt.GebDatum = monthCalendar.SelectionStart;
        }

        #region Schnittstelle IBeobachter

        public void Aktualisiere(Subjekt subjekt)
        {
            if (subjekt == null) return;

            this.monthCalendar.SelectionStart = subjekt.GebDatum;
            this.monthCalendar.SelectionEnd = subjekt.GebDatum;
        }

        #endregion
    }
}
