﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace EventObserver
{
    public partial class EigenschaftenBeobachter :
        UserControl
    {
        public EigenschaftenBeobachter()
        {
            InitializeComponent();
        }

        private ISubjekt _subjekt;
        public ISubjekt Subjekt
        {
            set
            {
                if (_subjekt != null)
                    _subjekt.Aktualisiert -= new EventHandler<SubjektEventArgs>(_subjekt_Aktualisiert);

                _subjekt = value;
                _subjekt_Aktualisiert(this, new SubjektEventArgs(value));

                if (_subjekt != null)
                    _subjekt.Aktualisiert += new EventHandler<SubjektEventArgs>(_subjekt_Aktualisiert);
            }
        }

        void _subjekt_Aktualisiert(object sender, SubjektEventArgs e)
        {
             if (e.Subjekt == null)
                iSubjektBindingSource.DataSource = typeof(ISubjekt);
            else
                this.iSubjektBindingSource.DataSource = e.Subjekt;

            this.iSubjektBindingSource.ResetBindings(false);
        }
    }
}
