﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace EventObserver
{
    public partial class DatumBeobachter :
        UserControl
    {
        public DatumBeobachter()
        {
            InitializeComponent();
        }

        private ISubjekt _subjekt;
        public ISubjekt Subjekt
        {
            set
            {
                if (_subjekt != null) _subjekt.Aktualisiert -= new EventHandler<SubjektEventArgs>(Aktualisiert);
                _subjekt = value;
                Aktualisiert(this, new SubjektEventArgs(value));
                if (_subjekt != null) _subjekt.Aktualisiert += new EventHandler<SubjektEventArgs>(Aktualisiert);
            }
        }

        #region EventHandler Member

        private void Aktualisiert(object sender, SubjektEventArgs e)
        {
            if (e.Subjekt == null) return;

            this.monthCalendar.SelectionStart = e.Subjekt.GebDatum;
            this.monthCalendar.SelectionEnd = e.Subjekt.GebDatum;
        }

        #endregion

        private void monthCalendar_DateChanged(object sender, DateRangeEventArgs e)
        {
            this._subjekt.GebDatum = monthCalendar.SelectionStart;
        }
    }
}
