﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

using CommandLine;
using CommandLine.Text;


namespace HelloHelp
{

    class HelloHelp
    {
        class Options
        {
            [Option("o", "outfile", HelpText = "The path of the file to be written", Required = true)]
            public string FilePath = null;

            [Option("n", null, HelpText = "How many times should \"Hello World\" be written?")]
            public int Times = 1;

            [Option("v", "verbose", HelpText = "Activate verbose mode")]
            public bool Verbose = false;

            [HelpOption("h", "help", HelpText = "Display this help information")]
            public string GetUsage()
            {
                HelpText help = new HelpText("HELLO");                
                help.AddOptions(this);
                return help;
            }
        }


        public void WriteHello(string[] args)
        {
            Options options = new Options();
            CommandLineParser parser = new CommandLineParser();

            if (parser.ParseArguments(args, options, Console.Out))
            {
                List<string> lines = new List<string>();
                for (int i = 0; i < options.Times; i++)
                {
                    lines.Add("Hello World");

                    if (options.Verbose)
                        Console.Out.WriteLine("wrote Hello World...");
                }
                File.WriteAllLines(options.FilePath, lines.ToArray());
            }
        }
    }
}
