using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Documents;
using System.Windows.Markup;
using System.IO;
using System.Data;
using System.Windows.Xps.Packaging;

namespace FlowDocReporting
{
	public class ReportEngine
    {
        static List<FormattedRun> displayItems;

        static ParserContext xamlContext;
        /// <summary>
        /// Helps in namespace mapping during Xaml loading for each template
        /// </summary>
        public static ParserContext XamlContext
        {
            get
            {
                if (xamlContext == null)
                {
                    xamlContext = new ParserContext();
                    xamlContext.XmlnsDictionary.Add("", "http://schemas.microsoft.com/winfx/2006/xaml/presentation");
                    xamlContext.XmlnsDictionary.Add("c", "http://reportcontrols");
                }
                return xamlContext;
            }
        }

        /// <summary>
        /// Creates report part according to specific template , and "binds" the data 
        /// </summary>
        internal static T  createReportPart<T>(string template,object data) where T:TextElement
        {
            T templatedItem;
         
            MemoryStream ms = new MemoryStream(System.Text.Encoding.UTF8.GetBytes(template));
            templatedItem = (T)XamlReader.Load(ms, XamlContext);
            if (data != null)
            {

                DocumentWalker dw = new DocumentWalker();
                dw.VisualVisited += new DocumentVisitedEventHandler(dw_VisualVisited);
                displayItems = new List<FormattedRun>();
                if (typeof(T) ==typeof(Paragraph))
                    dw.TraverseParagraph(templatedItem as Paragraph);
                else if (typeof(T) == typeof(Section))
                {
                    Section sec = templatedItem as Section;
                    foreach (Block b in sec.Blocks)
                    {
                        Paragraph p =b as Paragraph;
                        if (p!=null)
                            dw.TraverseParagraph(p);
                    }
                }
                else if (typeof(T) == typeof(TableRow))
                {
                    TableRow tr = templatedItem as TableRow;
                    foreach (TableCell tc in tr.Cells)
                        dw.TraverseBlockCollection(tc.Blocks);
                }
                else if (typeof(T) == typeof(TableRowGroup))
                {
                    TableRowGroup trg = templatedItem as TableRowGroup;
                    foreach (TableRow tr in trg.Rows)
                    {
                        foreach (TableCell tc in tr.Cells)
                            dw.TraverseBlockCollection(tc.Blocks);
                    }
                }

                foreach (FormattedRun fRun in displayItems)
                {
                    if (data is DataRow)
                    {
                        DataRow row=data as DataRow;
                        if (row.Table.Columns.Contains(fRun.PropertyName))
                            fRun.Data = row[fRun.PropertyName];
                    }
                    else if (data is GroupData)
                    {
                        GroupData gd = data as GroupData;
                        fRun.Data = gd.GetComputedValue(fRun.PropertyName);
                    }
                }
            }

            return templatedItem;
        }

        static void dw_VisualVisited(object sender, object visitedObject, bool start)
        {
            FormattedRun fRun = visitedObject as FormattedRun;
            if (fRun != null)
                displayItems.Add(fRun);
        }


        void copyFromRowGroup(string template, TableRowGroup trg,GroupData r)
        {
            TableRowGroup gf = createReportPart<TableRowGroup>(template, r);
            TableRow[] rows = new TableRow[gf.Rows.Count];

            gf.Rows.CopyTo(rows, 0);
            gf.Rows.Clear();

            for (int j = 0; j < rows.Length; j++)
            {
                TableRow tr = rows[j];
                trg.Rows.Add(tr);
            }
        }
       
        void addGroup(ReportDefinition rd, TableRowGroup trg, GroupData group,DataTable rData)
        {
           copyFromRowGroup(rd.Groups[group.Level].HeaderTemplate, trg, group);
            if (group.HasNestedGroups)
            {
                foreach (GroupData g in group.NestedDataGroups)
                    addGroup(rd,trg,g,rData);
            }
            else
            {
                int endRow=group.StartRow+group.Count;
                for (int i=group.StartRow;i<endRow;i++)
                {
                    DataRow r = rData.Rows[i];
                    trg.Rows.Add(createReportPart<TableRow>(rd.ItemTemplate, r));
                }
            }
            copyFromRowGroup(rd.Groups[group.Level].FooterTemplate,trg,group);

        }
     
        public XpsDocument  CreateReport(ReportDefinition rd, ReportData rData)
        {
            int pageWidth = 700;//just for testing !! get it from your printer
            FlowDocument fd = new FlowDocument();
            fd.ColumnWidth = pageWidth - 100;
            fd.Blocks.Add(createReportPart<Section>(rd.HeaderTemplate,rData.ReportGroup));
            TableRowGroup trg = new TableRowGroup();
           
            for (int i = 0; i < rData.Groups.Count;i++ )
            {
                addGroup(rd,trg, rData.Groups[i],rData.Rows);
            }
            MemoryStream tableStream = new MemoryStream(System.Text.Encoding.UTF8.GetBytes(rd.TableDefinition));
            Table table = (Table)XamlReader.Load(tableStream,XamlContext);
            table.RowGroups.Add(trg);
            fd.Blocks.Add(table);
            fd.Blocks.Add(createReportPart<Section>(rd.FooterTemplate, rData.ReportGroup));
            return ReportPaginator.CreateXpsDocument(fd,rd.Page); 

        }
    }
}