using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Documents;
using System.Data;

namespace FlowDocReporting
{

    class DecimalAggregateField : AggregateField
    {
        decimal value;
        public DecimalAggregateField(int ordinal) : base(ordinal) { }
        public override void UpdateValue(IDataReader reader)
        {
            decimal d = reader.GetDecimal(ordinal);
            switch (Aggregate)
            {
                case AggegateType.Sum: value += d; break;
                default: throw new NotImplementedException();
            }
        }

        public override object Value
        {
            get { return value; }
        }

    }
}