using System;
using System.Collections.Generic;
using System.Text;
using log4net.Appender;
using log4net;

namespace BonnToCode.Logging.Demo
{
    public class ToolboxAppender : AppenderSkeleton
    {
        #region Properties

        static int width = 150;
        static int height = 150;

        /// <summary>
        /// Hhe des Formulars
        /// </summary>
        /// <remarks>Wegen der statischen Instanz des Formulars wird die Instanzproperty auf die
        /// statische Variable gemappt</remarks>
        public int Height
        {
            get { return height; }
            set { height = value; }
        }

        /// <summary>
        /// Breite des Formulars
        /// </summary>
        /// <remarks>Wegen der statischen Instanz des Formulars wird die Instanzproperty auf die
        /// statische Variable gemappt</remarks>
        public int Width
        {
            get { return width; }
            set { width = value; }
        }

        #endregion

        #region LoggingForm

        private static LoggingForm logFrm = null;

        /// <summary>
        /// Anzeigen bzw. instanziieren des Formulars
        /// </summary>
        public static void ShowForm()
        {
            if (logFrm == null)
            {
                logFrm = new LoggingForm();
                // Dispose erzwingt ein verwefen des Formulars (kein Logging, wenn kein Formular)
                logFrm.Disposed += new EventHandler(logFrm_Disposed);
                logFrm.Width = width;
                logFrm.Height = height;
            }
            logFrm.Show();
        }

        /// <summary>
        /// Verwerfen der Referenz auf das Formular. Ansonsten wird auf ein verworfener Speicher zugeriffen
        /// </summary>
        static void logFrm_Disposed(object sender, EventArgs e)
        {
            logFrm = null;
        }

        #endregion

        /// <summary>
        /// Hinzufgen einer log-Nachricht zur Textbox im Formular
        /// </summary>
        protected override void Append(log4net.Core.LoggingEvent loggingEvent)
        {
            if (logFrm == null) return;

            string renderedMessage = this.RenderLoggingEvent(loggingEvent);
            logFrm.Append(renderedMessage);
        }
    }
}
