using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace BonnToCode.Logging.Demo
{
    /// <summary>
    /// Klasse mit mathematischen Funktionen.
    /// </summary>
    /// <remarks>Danke Jan fr http://www.dotnet-snippets.de</remarks>
    internal class Math
    {
        #region Log4Net

        /// <summary>
        /// log4net Logger Instanz
        /// </summary>
        private static readonly log4net.ILog log =
            log4net.LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);

        #endregion

        /// <summary>
        /// Berechnet die Quersumme einer Zahl
        /// </summary>
        /// <param name="Zahl">Die Zahl, aus der die Quersumme berechnet werden soll</param>
        /// <returns>Die Quersumme</returns>
        /// <see>http://dotnet-snippets.de/dns/quersummenberechnung-SID951.aspx</see>
        internal static int Quersumme(int iNumber)
        {
            if (log.IsDebugEnabled) log.Debug("Quersumme von " + iNumber.ToString() + " berechnen");
            //Zahl in einen String aufteilen
            string strNumbers = iNumber.ToString();
            iNumber = 0;
            List<int> lstParts = new List<int>();

            foreach (char ch in strNumbers)
            {
                lstParts.Add(Convert.ToInt32(ch.ToString()));
            }

            foreach (int i in lstParts)
            {
                iNumber = iNumber + i;
            }

            return iNumber;

        }

        /// <summary>
        /// Prfen auf eine Primzahl
        /// </summary>
        /// <param name="Number">Zu prfende Zahl</param>
        /// <returns>False, wenn die Zahl eine Primzahl ist</returns>
        /// <see>http://dotnet-snippets.de/dns/pruefen-ob-eine-zahl-eine-primzahl-ist-SID227.aspx</see>
        internal static bool CheckPrime(long Number)
        {
            for (long i = 2; i <= Number - 1; i++)
            {
                if (Number % i == 0) return true;
            }
            return false;
        }

        /// <summary>
        /// Prfen auf eine Primzahl. Es werden nur alle ungeraden Zahlen bis zur Wrzel der
        /// zu prfenden Zahl getestet.
        /// </summary>
        /// <param name="Number">Zu prfende Zahl</param>
        /// <returns>True, wenn die Zahl eine Primzahl ist</returns>
        /// <see>http://dotnet-snippets.de/dns/primzahl-berechnen-optimiert-SID1075.aspx</see>
        internal static bool IsPrimeNumber(long testNumber)
        {
            if (log.IsInfoEnabled) log.Info("Primzahl berechnen von "+testNumber.ToString());
            if (testNumber < 2) return false;

            // Die 2 explizit testen
            if (testNumber % 2 == 0) return false;

            long upperBorder = (long)System.Math.Truncate(System.Math.Sqrt(testNumber));

            for (long i = 3; i <= upperBorder; i = i + 2)
            {
                if (log.IsDebugEnabled) log.Debug("Testen von " + i.ToString());
                if (testNumber % i == 0) return false;
            }
            return true;
        }

        /// <summary>
        /// Berechnet den GGT der Zahlen n und m
        /// </summary>
        /// <param name="n">Erste Zahl</param>
        /// <param name="m">Zweite Zahl</param>
        /// <returns>GGT von n und m</returns>
        /// <see>http://dotnet-snippets.de/dns/groessten-gemeinsamen-teiler-berechnen-SID192.aspx</see>
        internal static int ggT(int n, int m)
        {
            if (log.IsDebugEnabled) log.Debug(string.Format("ggt von {0} und {1}", n, m));
            return n == m ? n : n < m ? ggT(n, m - n) : ggT(n - m, m);
        }

        /// <summary>
        /// Berechnet die n-te Fibonacci Zahl rekursiv
        /// </summary>
        /// <param name="n">Stelle der Fibonacci Zahl</param>
        /// <returns>n. Fibbonacci Zahl</returns>
        /// <see>http://dotnet-snippets.de/dns/c-n-te-fibonaccizahl-rekursiv-berechnen-SID189.aspx</see>
        internal static int Fibonacci(int n)
        {
            return n == 1 ? 1 : n == 2 ? 1 : Fibonacci(n - 1) + Fibonacci(n - 2);
        }

    }
}
