using System;
using System.Collections.Generic;
using System.Text;
using BonnToCode.Logging.Framework.Internal;

namespace BonnToCode.Logging.Framework
{
    public static class LogManager
    {
        private static IList<ILog> log = new List<ILog>();
        private static IList<IAppender> appender = new List<IAppender>();

        public static ILog GetLogger(Type context)
        {
            Log res = new Log(context);

            foreach (IAppender app in appender)
            {
                res.AddAppender(app);
            }

            log.Add(res);
            return res;
        }

        public static void AddAppender(IAppender initAppender)
        {
            appender.Add(initAppender);
            foreach (ILog aLog in log)
            {
                ((Log)aLog).AddAppender(initAppender);
            }
        }
    }
}
