using System;
using System.Collections.Generic;
using System.Text;

namespace BonnToCode.Logging.Framework.Internal
{
    internal class Log : ILog
    {
        private List<IAppender> appender = new List<IAppender>();
        private Type context = null;

        internal Log(Type initContext)
        {
            this.context = initContext;
        }

        #region ILog Member

        public void Debug(string message)
        {
            this.LogMessage(LogLevel.Debug, message);
        }

        public void Info(string message)
        {
            this.LogMessage(LogLevel.Info, message);
        }

        public void Error(string message)
        {
            this.LogMessage(LogLevel.Error, message);
        }

        private void LogMessage(LogLevel level, string message)
        {
            foreach (IAppender appender in this.appender)
            {
                appender.AppendMessage(this.context, level, message);
            }
        }

        #endregion

        internal void AddAppender(IAppender appender)
        {
            this.appender.Add(appender);
        }
    }
}
