using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace BonnToCode.Logging.Demo
{
    [TestFixture()]
    public class MathTest
    {
        [Test()]
        public void ggT_Test()
        {
            int res;
            res = Math.ggT(4, 5);
            Assert.AreEqual(1, res);
            res = Math.ggT(5, 5);
            Assert.AreEqual(5, res);
            res = Math.ggT(20, 8);
            Assert.AreEqual(4, res);
            res = Math.ggT(20, 8);
            Assert.AreNotEqual(6, res);
        }

        [Test()]
        public void Fibonacci_Test()
        {
            int res;
            res = Math.Fibonacci(3);
            Assert.AreEqual(2, res);
            res = Math.Fibonacci(4);
            Assert.AreEqual(3, res);
            res = Math.Fibonacci(5);
            Assert.AreEqual(5, res);
        }

        [Test()]
        public void CheckPrime_Test()
        {
            bool res;
            res = Math.CheckPrime(5);
            Assert.AreEqual(false, res);
            res = Math.CheckPrime(1);
            Assert.AreEqual(false, res);
            res = Math.CheckPrime(9);
            Assert.AreEqual(true, res);
            res = Math.CheckPrime(2);
            Assert.AreEqual(false, res);
        }

        [Test()]
        public void CheckPrime_With_IsPrimeNumber_Test()
        {
            for (int i = 3; i < 100; i++)
            {
                bool resCP = !Math.CheckPrime(i);
                bool resIP = Math.IsPrimeNumber(i);
                Assert.AreEqual(resCP, resIP, "Primzahl Vergleich fuer " + i.ToString());
            }
        }

        [Test()]
        public void Quersumme_Test()
        {
            int res;
            res = Math.Quersumme(5);
            Assert.AreEqual(5, res);
            res = Math.Quersumme(55);
            Assert.AreEqual(10, res);
            res = Math.Quersumme(12345);
            Assert.AreEqual(15, res);
        }
    }
}
