﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using CommonDataProvider;

namespace SimpleWPF
{
    /// <summary>
    /// Interaction logic for Window1.xaml
    /// </summary>
    public partial class Window1 : Window
    {
        DataProvider provider;

        public Window1()
        {
            InitializeComponent();

            provider = new DataProvider();

            Refresh();
        }

        private void Refresh()
        {
            List<Employee> employees = provider.LoadAllEmployees();

            this.DataContext = employees;
        }

        void btDelete_Click(object sender, RoutedEventArgs e)
        {
            if (lvEmployee.SelectedItems.Count != 1)
                return;

            Employee selectedEmployee = lvEmployee.SelectedItem as Employee;

            provider.DeleteEmployee(selectedEmployee);

            Refresh();
        }

        void btEdit_Click(object sender, RoutedEventArgs e)
        {
            if (lvEmployee.SelectedItems.Count!=1)
                return;
            Employee selectedEmployee = lvEmployee.SelectedItem as Employee;

            EmployeeEditor editor = new EmployeeEditor(selectedEmployee);
            
            bool? result = editor.ShowDialog();
            if (result != null && result.Value)
            {
                provider.SaveEmployee(editor.Employee);
            }            

            Refresh();
        }

        void btAdd_Click(object sender, RoutedEventArgs e)
        {
            EmployeeEditor editor = new EmployeeEditor(new Employee());

            bool? result = editor.ShowDialog();
            if (result != null && result.Value)
            {
                provider.SaveEmployee(editor.Employee);
            }

            Refresh();
        }
       
    }
}
