﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace PropertyViewModel
{
    public class PropertyViewModel<T> : INotifyPropertyChanged
    {
        

        public PropertyViewModel(T originalValue)
        {
            this.originalValue = originalValue;
            Value = originalValue;
        }

        public void AcceptChanges()
        {
            originalValue = Value;
            HasChanges = false;
        }

        public void DiscardChanges()
        {
            Value = originalValue;
            HasChanges = false;
        }

        private T originalValue;


        private T myValue;

        public T Value
        {
            get
            {
                return myValue;
            }
            set
            {
                if (myValue != null && value != null && value.Equals(myValue))
                    return;

                myValue = value;
                FirePropertyChanged("Value");

                HasChanges = (originalValue == null && myValue != null)
                    || (originalValue != null && myValue == null)
                    || (originalValue != null && myValue != null && !myValue.Equals(originalValue));
            }
        }

        private bool hasChanges = false;
        public bool HasChanges
        {
            get
            {
                return hasChanges;
            }
            set
            {
                if (value == hasChanges)
                    return;
                hasChanges = value;

                FirePropertyChanged("HasChanges");
            }
        }



        #region INotifyPropertyChanged Members

        public event PropertyChangedEventHandler PropertyChanged;

        public void FirePropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }

        }
        #endregion


        public static implicit operator T(PropertyViewModel<T> propertyViewModel)
        {
            return propertyViewModel.Value;
        }
    }
}
