﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Input;

namespace PropertyViewModel
{
    class MainViewModel
    {
        public MainViewModel()
        {
            FirstName = new PropertyViewModel<string>("Hugh");
            LastName = new PropertyViewModel<string>("Everett");
            BirthYear = new PropertyViewModel<int>(1930);
            IsVegetarian = new PropertyViewModel<bool>(false);


            Save = new CommandBinding(ApplicationCommands.Save, Save_Executed);
            Undo = new CommandBinding(ApplicationCommands.Undo, Undo_Executed);
        }
        

        public PropertyViewModel<string> FirstName { get; set; }

        public PropertyViewModel<string> LastName { get; set; }

        public PropertyViewModel<int> BirthYear { get; set; }

        public PropertyViewModel<bool> IsVegetarian { get; set; }

        public CommandBinding Save { get; set; }
        private void Save_Executed(object sender, ExecutedRoutedEventArgs args)
        {
            FirstName.AcceptChanges();
            LastName.AcceptChanges();
            BirthYear.AcceptChanges();
            IsVegetarian.AcceptChanges();
        }

        public CommandBinding Undo { get; set; }
        private void Undo_Executed(object sender, ExecutedRoutedEventArgs args)
        {
            FirstName.DiscardChanges();
            LastName.DiscardChanges();
            BirthYear.DiscardChanges();
            IsVegetarian.DiscardChanges();
        }
    }
}
