﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using CommonDataProvider;
using System.Collections.ObjectModel;
using System.Windows.Input;

namespace Model_View_ViewModelSimple
{
    public class ViewModel : INotifyPropertyChanged
    {
        public ViewModel()
        {
            EmployeeCollection = new ObservableCollection<Employee>();

            provider = new DataProvider();

            provider.IsSlow = false;

            Add = new CommandBinding(Commands.Add, Add_Executed);            
            Edit = new CommandBinding(Commands.Edit, Edit_Executed);
            //We're using the default Application Commands for Delete!
            Delete = new CommandBinding(ApplicationCommands.Delete, Delete_Executed);

            Refresh();

            
        }

        DataProvider provider;

        private void Refresh()
        {
            //Idempotent...
            EmployeeCollection.Clear();

            List<Employee> employees = provider.LoadAllEmployees();

            foreach (var employee in employees)
            {
                EmployeeCollection.Add(employee);
            }
        }

        public ObservableCollection<Employee> EmployeeCollection { get; private set; }


        #region Add
        public CommandBinding Add { get; private set; }
        private void Add_Executed(object sender, ExecutedRoutedEventArgs args)
        {
            AddEventArgs addArgs = new AddEventArgs();


            FireAdd(addArgs);

            if (addArgs.AddConfirmed)
            {
                //Save the changes
                provider.SaveEmployee(addArgs.NewEmployee);

                Refresh();
            }
        }

        public event AddEventHandler AddRequested;

        private void FireAdd(AddEventArgs args)
        {           
            if (AddRequested != null)
            {
                AddRequested(this, args);
            }
        }

        #endregion

        #region Edit
        public CommandBinding Edit { get; private set; }
        private void Edit_Executed(object sender, ExecutedRoutedEventArgs args)
        {
            //Extract the current element
            Employee selectedEmployee = args.Parameter as Employee;
            
            if (selectedEmployee == null)
                //Seems nothing is selected
                return;


            //Copy the employee
            Employee employeeCopy = Utilities.CreateCopy<Employee>(selectedEmployee);

            EditEventArgs editArgs = new EditEventArgs
            {
                Employee = employeeCopy
            };

            FireEdit(editArgs);

            if (editArgs.AcceptChanges)
            {
                //Save the changes
                provider.SaveEmployee(editArgs.Employee);
                Refresh();
            }

        }

        public event EditEventHandler EditRequested;

        private void FireEdit(EditEventArgs args)
        {           
            if (EditRequested != null)
            {
                EditRequested(this, args);
            }

        }

        #endregion

        #region Delete
        public CommandBinding Delete { get; private set; }
        private void Delete_Executed(object sender, ExecutedRoutedEventArgs args)
        {
            //Extract the current element
            Employee selectedEmployee = args.Parameter as Employee;

            if (selectedEmployee == null)
                //Seems nothing is selected
                return;

            provider.DeleteEmployee(selectedEmployee);
            
            Refresh();
        }
        #endregion


        #region INotifyPropertyChanged Members

        private void FirePropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        #endregion
    }
}
