﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using CommonDataProvider;

namespace Model_View_ViewModel_Enhanced
{
    /// <summary>
    /// Interaction logic for Window1.xaml
    /// </summary>
    public partial class Window1 : Window
    {
        public Window1()
        {
            InitializeComponent();

            viewModel = new ViewModel();                        
            DataContext = viewModel;

            attachCommands();
            attachEvents();
                        
            PreviewKeyDown += new KeyEventHandler(Window1_PreviewKeyDown);
        }

        private ViewModel viewModel = null;

        void Window1_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            //Stop the user from pressing keys while the viewModel is busy
            e.Handled = viewModel.IsBusy;
        }

        private void attachCommands()
        {
            CommandBindings.Add(viewModel.Add);
            CommandBindings.Add(viewModel.Edit);
            CommandBindings.Add(viewModel.Delete);
            CommandBindings.Add(viewModel.ChangeLastNameSort);
        }

        private void attachEvents()
        {
            viewModel.AddRequested += new AddEventHandler(viewModel_AddRequested);
            viewModel.EditRequested += new EditEventHandler(viewModel_EditRequested);
        }

        void viewModel_EditRequested(object sender, EditEventArgs args)
        {
            EmployeeEditor editor = new EmployeeEditor(args.Employee);

            bool? result = editor.ShowDialog();

            args.AcceptChanges = (result.HasValue && result.Value);
        }

        void viewModel_AddRequested(object sender, AddEventArgs args)
        {
            EmployeeEditor editor = new EmployeeEditor(new Employee());

            bool? result = editor.ShowDialog();

            args.AddConfirmed = (result.HasValue && result.Value);
            args.NewEmployee = editor.Employee;
        }         
    }
}
