﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Data;
using CommonDataProvider;
using System.Windows.Media.Imaging;

namespace Model_View_ViewModel_Enhanced
{
    public class DepartmentConverter : IValueConverter
    {
        #region IValueConverter Members

        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (!(value is Departments))
                return null;

            Departments department = (Departments)value;

            BitmapImage image = null;

            switch (department)
            {
                case Departments.Production:
                    image = new BitmapImage(new Uri(@"Images/Production.png", UriKind.RelativeOrAbsolute));
                    break;
                case Departments.Administration:
                    image = new BitmapImage(new Uri(@"Images/Admin.png", UriKind.RelativeOrAbsolute));
                    break;
                case Departments.Sales:
                    image = new BitmapImage(new Uri(@"Images/Sales.png", UriKind.RelativeOrAbsolute));
                    break;
                case Departments.Marketing:
                    image = new BitmapImage(new Uri(@"Images/Marketing.png", UriKind.RelativeOrAbsolute));
                    break;
                case Departments.Research:
                    image = new BitmapImage(new Uri(@"Images/Research.png", UriKind.RelativeOrAbsolute));
                    break;
                default:
                    break;
            }
            return image;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }

        #endregion
    }
}
