﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CommonDataProvider;

namespace SimpleWinForms
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            provider = new DataProvider();

            refresh();

        }

        DataProvider provider;

        private void refresh()
        {
            List<Employee> allEmployees = provider.LoadAllEmployees();

            dgEmployees.Rows.Clear();

            foreach (Employee employee in allEmployees)
            {
                DataGridViewRow row = new DataGridViewRow();
                row.CreateCells(dgEmployees);

                row.Cells[0].Value = employee.LastName;
                row.Cells[1].Value = employee.FirstName;
                row.Cells[2].Value = employee.Department;

                row.Tag = employee;

                dgEmployees.Rows.Add(row);
            }
        }

        private void btAdd_Click(object sender, EventArgs e)
        {
            using (EmployeeEditor editor = new EmployeeEditor(new Employee()))
            {
                DialogResult result = editor.ShowDialog();
                if (result == DialogResult.OK)
                {
                    //Get the new employee and save it
                    provider.SaveEmployee(editor.Employee);
                }
            }

            refresh();

        }

        private void btEdit_Click(object sender, EventArgs e)
        {
            //Get the currently selected Employee
            if (dgEmployees.SelectedRows.Count != 1)
                return;

            Employee selectedEmployee = dgEmployees.SelectedRows[0].Tag as Employee;

            using (EmployeeEditor editor = new EmployeeEditor(selectedEmployee))
            {
                DialogResult result = editor.ShowDialog();
                if (result == DialogResult.OK)
                {
                    //Get the new employee and save it
                    provider.SaveEmployee(editor.Employee);
                }
            }

            refresh();
        }

        private void btDelete_Click(object sender, EventArgs e)
        {
            //Get the currently selected Employee
            if (dgEmployees.SelectedRows.Count != 1)
                return;

            Employee selectedEmployee = dgEmployees.SelectedRows[0].Tag as Employee;

            provider.DeleteEmployee(selectedEmployee);

            refresh();
        }
    }
}
