﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CommonDataProvider;

namespace SimpleWinForms
{
    public partial class EmployeeEditor : Form
    {
        public EmployeeEditor(Employee employee )
        {
            InitializeComponent();

            this.Employee = employee;

            fillEditor();
        }

        private void fillEditor()
        {
            tbLastName.Text = Employee.LastName;
            tbFirstName.Text = Employee.FirstName;

            fillCombobox();
        }

        public Employee Employee { get; set; }

        private void fillCombobox()
        {            
            foreach (Departments dep in Enum.GetValues(typeof(Departments)))
            {
                cbDepartment.Items.Add(dep);
            }

            cbDepartment.SelectedItem = Employee.Department;
        }

        private void btOK_Click(object sender, EventArgs e)
        {
            Employee.FirstName = tbFirstName.Text;
            Employee.LastName= tbLastName.Text;
            Employee.Department = (Departments)cbDepartment.SelectedItem;
            
            DialogResult = DialogResult.OK;
            Close();
        }

        private void btCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}
