﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Xml;
using System.IO;

namespace CommonDataProvider
{
    public class Utilities
    {
        private static string ToXml(object o)
        {
            XmlSerializer serializer = new XmlSerializer(o.GetType());
            StringBuilder builder = new StringBuilder();
            XmlWriter writer = XmlWriter.Create(builder);
            serializer.Serialize(writer, o);

            string xml = builder.ToString();
            return xml;
        }

        private static T FromXml<T>(string xml) where T : class
        {
            XmlSerializer serializer = new XmlSerializer(typeof(T));

            StringReader reader = new StringReader(xml);

            T result = serializer.Deserialize(reader) as T;

            return result;
        }

        public static T CreateCopy<T>(T objectToCopy) where T : class
        {
            string xml = ToXml(objectToCopy);
            T result = FromXml<T>(xml);

            return result;
        }
    }
}
