﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Xml;
using System.IO;
using System.Threading;

namespace CommonDataProvider
{
    public class DataProvider
    {
        public DataProvider()
        {
            preFillEmployees();
        }

        public bool IsSlow {get; set;}

        private void beforeSendBack()
        {
            if (IsSlow)
                Thread.Sleep(5000);
        }


        public List<Employee> LoadAllEmployees()
        {
            List<Employee> result = getAllEmployees();

            beforeSendBack();
            return result;           
        }

        public void SaveEmployee (Employee toSave)
        {
            //First get a copy
            Employee employeeCopy = Utilities.CreateCopy<Employee>(toSave);

            //Check whether we know him/her
            Employee existingEmployee = 
                allEmployees.Find(employee => employee.ID == employeeCopy.ID);

            //if so: Remove him/her
            if (existingEmployee != null)
            {                
                allEmployees.Remove(existingEmployee);
            }

            //And add the employee as a new one
            allEmployees.Add(employeeCopy);
            beforeSendBack();
        }

        public void DeleteEmployee(Employee toDelete)
        {
            //Check whether we know him/her
            Employee existingEmployee =
                allEmployees.Find(employee => employee.ID == toDelete.ID);

            //if so: Remove him/her
            if (existingEmployee != null)
            {
                allEmployees.Remove(existingEmployee);
            }

            beforeSendBack();
        }

        private List<Employee> getAllEmployees()
        {            
            var employees = Utilities.CreateCopy<List<Employee>>(allEmployees);
            return employees;            
        }

       

        private List<Employee> allEmployees = null;

        private void preFillEmployees()
        {
            allEmployees = new List<Employee>
            {                
                new Employee
                {
                    FirstName = "Frank",
                    LastName = "Müller",
                    Birthday = new DateTime(1960, 03, 19),
                    InternalName ="muellerf",
                    Salary = 90000.0,
                    Department = Departments.Production
                },
                new Employee
                {
                    FirstName = "Peter",
                    LastName = "Schmitz",
                    Birthday = new DateTime(1950, 01, 20),
                    InternalName ="rhodanp",
                    Salary = 100000.0,
                    Department = Departments.Administration
                },
                new Employee
                {
                    FirstName = "Andrea",
                    LastName = "Bender",
                    Birthday = new DateTime(1979, 07, 10),
                    InternalName ="bendera",
                    Salary = 90000.0,
                    Department = Departments.Marketing
                }
            };
        }


    }

   
}
