#include "StdAfx.h"
#include "RuntimeHost.h"

CRuntimeHost::CRuntimeHost(void)
{
}

CRuntimeHost::~CRuntimeHost(void)
{
}

void CRuntimeHost::Start(BOOL withOwnAppDomain)
{
	//Bind to .net runtime...
	HRESULT hr = CorBindToRuntimeEx(NULL, NULL,
		STARTUP_LOADER_OPTIMIZATION_SINGLE_DOMAIN |
		STARTUP_CONCURRENT_GC, __uuidof(CorRuntimeHost), 
		__uuidof(ICorRuntimeHost), (LPVOID*)&m_pHost);

	//...and start it
	hr = m_pHost->Start();

	if (withOwnAppDomain)
	{
		//get the path of executable
		WCHAR path[1024];
		DWORD pathLen = ::GetModuleFileName(NULL, path, 1024);
		*wcsrchr(path, L'\\') = 0;

		//prepare AppDomainSetup
		IUnknownPtr pSetupUnk;
		m_pHost->CreateDomainSetup(&pSetupUnk);

		mscorlib::IAppDomainSetupPtr pSetup(pSetupUnk);
		pSetup->put_ApplicationName (_bstr_t(L"Demo"));
		pSetup->put_ApplicationBase(_bstr_t(path));
		pSetup->put_ShadowCopyFiles(_bstr_t(L"true"));
		pSetup->put_CachePath(_bstr_t(path) + _bstr_t(L"\\cache"));

		//finally create AppDomain
		IUnknownPtr pDomainUnk;
		m_pHost->CreateDomainEx(_bstr_t(L"Demo"), pSetup, NULL, &pDomainUnk);

		//and remember it
		m_pAppDomain = pDomainUnk;
	}
	else
	{
		//just remember the default domain
		IUnknownPtr pDomainUnk;
		m_pHost->GetDefaultDomain(&pDomainUnk);
		m_pAppDomain = pDomainUnk;
	}
}
	
CNetWindowProxy* CRuntimeHost::CreateNetWindow(_bstr_t assembly, _bstr_t classname)
{
	//create .net object in our appdomain
	mscorlib::_ObjectHandlePtr pObjHandle;
	HRESULT hr = m_pAppDomain->CreateInstance(assembly, classname,  &pObjHandle) ;
 
	return new CNetWindowProxy(pObjHandle);

}
