using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.ServiceModel.Syndication;
using System.Xml;

namespace RSSFeeds
{
    public partial class RSSControl : UserControl
    {
        public RSSControl()
        {
            InitializeComponent();
        }

        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }

        class Entry
        {
            SyndicationItem m_item;
            SyndicationFeed m_feed;

            public Entry(SyndicationFeed feed, SyndicationItem item)
            {
                m_item = item;
                m_feed = feed;
            }

            public string Title
            {
                get { return m_item.Title.Text; }
            }

            public DateTimeOffset PublishDate
            {
                get { return m_item.PublishDate; }
            }

        }


        private void RSSControl_Load(object sender, EventArgs e)
        {
            this.UseWaitCursor = true;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            timer1.Stop();

            Uri feedUri = new Uri("http://weblogs.asp.net/rweigelt/rss.aspx");
            XmlReader reader = XmlReader.Create("http://weblogs.asp.net/rweigelt/rss.aspx");

            SyndicationFeed feed = SyndicationFeed.Load(reader);
            List<Entry> entries = new List<Entry>();
            foreach (SyndicationItem item in feed.Items) entries.Add(new Entry(feed, item));
            dataGridView1.DataSource = entries;

            dataGridView1.Columns[0].AutoSizeMode = DataGridViewAutoSizeColumnMode.Fill;
            dataGridView1.Columns[1].AutoSizeMode = DataGridViewAutoSizeColumnMode.Fill;
            dataGridView1.Columns[1].FillWeight = 50;

            this.UseWaitCursor = false;
        }
    }
}
