using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using drw = System.Drawing;
using vst = System.Windows.Forms.VisualStyles;

namespace DemoApplication
{
	/// <summary>
	/// Helper class for dealing with <see cref="TextFormatFlags"/> constants
	/// </summary>
	static class TextFormatFlagsHelper
	{
		/// <summary>
		/// Gets the text format flags from the specified content alignment.
		/// </summary>
		/// <param name="contentAlignment">The content alignment.</param>
		/// <returns>ORed <see cref="TextFormatFlags"/> constants.</returns>
		public static TextFormatFlags FromContentAlignment( drw.ContentAlignment contentAlignment )
		{
			TextFormatFlags eFlags = 0;
			switch (contentAlignment)
			{
				case drw.ContentAlignment.BottomCenter:
				case drw.ContentAlignment.BottomLeft:
				case drw.ContentAlignment.BottomRight:
					eFlags |= TextFormatFlags.Bottom;
					break;
				case drw.ContentAlignment.MiddleCenter:
				case drw.ContentAlignment.MiddleLeft:
				case drw.ContentAlignment.MiddleRight:
					eFlags |= TextFormatFlags.VerticalCenter;
					break;
				case drw.ContentAlignment.TopCenter:
				case drw.ContentAlignment.TopLeft:
				case drw.ContentAlignment.TopRight:
					eFlags |= TextFormatFlags.Top;
					break;
			}
			switch (contentAlignment)
			{
				case drw.ContentAlignment.BottomLeft:
				case drw.ContentAlignment.MiddleLeft:
				case drw.ContentAlignment.TopLeft:
					eFlags |= TextFormatFlags.Left;
					break;

				case drw.ContentAlignment.BottomCenter:
				case drw.ContentAlignment.MiddleCenter:
				case drw.ContentAlignment.TopCenter:
					eFlags |= TextFormatFlags.HorizontalCenter;
					break;

				case drw.ContentAlignment.BottomRight:
				case drw.ContentAlignment.MiddleRight:
				case drw.ContentAlignment.TopRight:
					eFlags |= TextFormatFlags.Right;
					break;
			}
			return eFlags;
		}

		/// <summary>
		/// Gets the text format flags from the specified content alignment.
		/// </summary>
		/// <param name="contentAlignment">The content alignment.</param>
		/// <returns>ORed <see cref="TextFormatFlags"/> constants.</returns>
		public static TextFormatFlags FromContentAlignment( vst.ContentAlignment contentAlignment )
		{
			TextFormatFlags eFlags = 0;
			switch (contentAlignment)
			{
				case vst.ContentAlignment.Center:
					eFlags |= TextFormatFlags.HorizontalCenter;
					break;
				case vst.ContentAlignment.Left:
					eFlags |= TextFormatFlags.Left;
					break;
				case vst.ContentAlignment.Right:
					eFlags |= TextFormatFlags.Right;
					break;
				default:
					break;
			}
			return eFlags;
		}

	}
}
