using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;
using System.Windows.Forms.VisualStyles;

namespace DemoApplication
{
	/// <summary>
	/// A special radiobutton
	/// </summary>
	public class SpecialRadioButton : RadioButton
	{
		/// <summary>
		/// Raises the <see cref="M:System.Windows.Forms.ButtonBase.OnPaint(System.Windows.Forms.PaintEventArgs)"></see> event.
		/// </summary>
		/// <param name="pevent">A <see cref="T:System.Windows.Forms.PaintEventArgs"></see> that contains the event data.</param>
		protected override void OnPaint( PaintEventArgs pevent )
		{
			Rectangle rect = this.ClientRectangle;
			//			--rect.Width;
			//			--rect.Height;

			using (Brush objBackgroundBrush = new SolidBrush( this.BackColor ))
			{
				pevent.Graphics.FillRectangle( objBackgroundBrush, rect );
			}

			PushButtonState ePushButtonState;
			if (this.Enabled)
				ePushButtonState = (this.Checked) ? PushButtonState.Pressed : PushButtonState.Normal;
			else
				ePushButtonState = PushButtonState.Disabled;

			RadioButtonState eRadioButtonState;
			if (this.Enabled)
				eRadioButtonState = this.Checked ? RadioButtonState.CheckedNormal : RadioButtonState.UncheckedNormal;
			else
				eRadioButtonState = this.Checked ? RadioButtonState.CheckedDisabled : RadioButtonState.UncheckedDisabled;

			Size szGlyph = RadioButtonRenderer.GetGlyphSize( pevent.Graphics, eRadioButtonState );

			Rectangle rtButton = rect;
			rtButton.Inflate( -(szGlyph.Width / 2), 0 );

			ButtonRenderer.DrawButton(
				pevent.Graphics,
				rtButton,
				this.Text,
				this.Font,
				TextFormatFlagsHelper.FromContentAlignment( this.TextAlign ),
				this.Focused,
				ePushButtonState );

			Point ptRadioButton = new Point(
				rect.Left + this.Padding.Left,
				rect.Top + ((rect.Height - this.Padding.Vertical - szGlyph.Height) / 2) );
			RadioButtonRenderer.DrawRadioButton( pevent.Graphics, ptRadioButton, eRadioButtonState );

			ptRadioButton.X = rect.Right - szGlyph.Width - this.Padding.Right;

			RadioButtonRenderer.DrawRadioButton( pevent.Graphics, ptRadioButton, eRadioButtonState );
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="SpecialRadioButton"/> class.
		/// </summary>
		public SpecialRadioButton()
		{
			this.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
		}
	}
}
