using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using vst=System.Windows.Forms.VisualStyles;

namespace DemoApplication
{
	/// <summary>
	/// Shows various renderers
	/// </summary>
	public class RendererDemoControl : Control
	{
		/// <summary>
		/// Paints the background of the control.
		/// </summary>
		/// <param name="pevent">A <see cref="T:System.Windows.Forms.PaintEventArgs"></see> that contains information about the control to paint.</param>
		protected override void OnPaintBackground( PaintEventArgs pevent )
		{
			base.OnPaintBackground( pevent );
			using (SolidBrush objBackground = new SolidBrush( this.BackColor ))
			{
				pevent.Graphics.FillRectangle( objBackground, this.ClientRectangle );
			}
		}

		/// <summary>
		/// Raises the <see cref="E:System.Windows.Forms.Control.Paint"></see> event.
		/// </summary>
		/// <param name="e">A <see cref="T:System.Windows.Forms.PaintEventArgs"></see> that contains the event data.</param>
		protected override void OnPaint( PaintEventArgs e )
		{
			Point ptStartPosition=new Point(this.ClientRectangle.X,this.ClientRectangle.Y);
			Point ptCurrentPosition = ptStartPosition;
			Size szRadioButton;
			Size szText;
			int nXOffset;
			int nYOffset;
			int nSecondColumnXOffset = 0;
			string strState;
			foreach (vst.RadioButtonState eState in Enum.GetValues( typeof( vst.RadioButtonState ) ))
			{
				strState = eState.ToString();
				RadioButtonRenderer.DrawRadioButton( e.Graphics, ptCurrentPosition, eState );
				szRadioButton = RadioButtonRenderer.GetGlyphSize( e.Graphics, eState );
				nXOffset = szRadioButton.Width + 2;
				nYOffset = szRadioButton.Height + 2;

				ptCurrentPosition.Offset( nXOffset, 0 );
				TextRenderer.DrawText( e.Graphics, strState, this.Font, ptCurrentPosition, this.ForeColor );
				ptCurrentPosition.Offset( -nXOffset, nYOffset );

				szText=TextRenderer.MeasureText(strState,this.Font);
				nSecondColumnXOffset = Math.Max( nSecondColumnXOffset, szText.Width );
			}
			nSecondColumnXOffset += 24; // some space between the two columns
			//
			// Classic renderer
			//
			ptStartPosition.Offset(nSecondColumnXOffset,0);
			ptCurrentPosition = ptStartPosition;
			szRadioButton=RadioButtonRenderer.GetGlyphSize( e.Graphics, vst.RadioButtonState.CheckedNormal );
			nXOffset = szRadioButton.Width + 2;
			nYOffset = szRadioButton.Height + 2;

			foreach (ButtonState eState in Enum.GetValues( typeof( ButtonState ) ))
			{
				strState = eState.ToString();
				ControlPaint.DrawRadioButton( e.Graphics, ptCurrentPosition.X, ptCurrentPosition.Y, szRadioButton.Width, szRadioButton.Height, eState );
				ptCurrentPosition.Offset( nXOffset, 0 );
				TextRenderer.DrawText( e.Graphics, strState, this.Font, ptCurrentPosition, this.ForeColor );

				ptCurrentPosition.Offset( -nXOffset, nYOffset );
			}
		}
	}
}
