using System;
using System.Collections.Generic;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Diagnostics;

namespace DemoApplication.Demo3
{
	/// <summary>
	/// Modified checkbox
	/// </summary>
	public class ModifiedCheckBox : CheckBox
	{
		private bool m_bHighlight = false;

		/// <summary>
		/// Raises the <see cref="M:System.Windows.Forms.ButtonBase.OnPaint(System.Windows.Forms.PaintEventArgs)"></see> event.
		/// </summary>
		/// <param name="pevent">A <see cref="T:System.Windows.Forms.PaintEventArgs"></see> that contains the event data.</param>
		protected override void OnPaint( PaintEventArgs pevent )
		{
			Rectangle rect = this.ClientRectangle;
			--rect.Width;
			--rect.Height;

			Color objBottomBackColor = this.Checked ? Color.Green : Color.Red;
			if (m_bHighlight)
				objBottomBackColor = ControlPaint.Light( objBottomBackColor );

			Color objTopBackColor = ControlPaint.LightLight( objBottomBackColor );

			using (Brush objBrush = new LinearGradientBrush( rect, objTopBackColor, objBottomBackColor, LinearGradientMode.Vertical ))
			{
				pevent.Graphics.FillRectangle( objBrush, rect );
			}

			using (Pen objPen = new Pen( Color.Black ))
			{
				pevent.Graphics.DrawRectangle( objPen, rect );
			}

			TextFormatFlags eFlags = TextFormatFlags.SingleLine;
			eFlags |= TextFormatFlagsHelper.FromContentAlignment( this.TextAlign );

			TextRenderer.DrawText(
				pevent.Graphics,
				this.Text,
				this.Font,
				rect,
				this.ForeColor,
				eFlags
				);
		}

		/// <summary>
		/// Raises the <see cref="M:System.Windows.Forms.Control.OnMouseEnter(System.EventArgs)"></see> event.
		/// </summary>
		/// <param name="eventargs">An <see cref="T:System.EventArgs"></see> that contains the event data.</param>
		protected override void OnMouseEnter( EventArgs eventargs )
		{
			base.OnMouseEnter( eventargs );
			m_bHighlight = true;
			Invalidate();
		}

		/// <summary>
		/// Raises the <see cref="E:System.Windows.Forms.Control.MouseUp"></see> event.
		/// </summary>
		/// <param name="e">A <see cref="T:System.Windows.Forms.MouseEventArgs"></see> that contains the event data.</param>
		protected override void OnMouseUp( MouseEventArgs e )
		{
			base.OnMouseUp( e );
			m_bHighlight = true;
			Invalidate();
		}

		/// <summary>
		/// Raises the <see cref="E:System.Windows.Forms.Control.MouseLeave"></see> event.
		/// </summary>
		/// <param name="e">An <see cref="T:System.EventArgs"></see> that contains the event data.</param>
		protected override void OnMouseLeave( EventArgs e )
		{
			base.OnMouseLeave( e );
			m_bHighlight = false;
			Invalidate();
		}
	}
}
