using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.ComponentModel;

namespace DemoApplication
{
	/// <summary>
	/// A panel with a border matching the current theme
	/// </summary>
	public class PanelWithThemedBorder : Panel
	{
		/// <summary>
		/// Raises the <see cref="E:System.Windows.Forms.Control.Paint"></see> event.
		/// </summary>
		/// <param name="e">A <see cref="T:System.Windows.Forms.PaintEventArgs"></see> that contains the event data.</param>
		protected override void OnPaint( PaintEventArgs e )
		{
			base.OnPaint( e );
			Rectangle rect = this.ClientRectangle;
			--rect.Width;
			--rect.Height;
			ControlPaint.DrawVisualStyleBorder( e.Graphics, rect );
		}

		/// <summary>
		/// Gets or sets padding within the control.
		/// </summary>
		/// <value></value>
		/// <returns>A <see cref="T:System.Windows.Forms.Padding"></see> representing the control's internal spacing characteristics.</returns>
		public new Padding Padding
		{
			get { return base.Padding; }
			set
			{
				base.Padding = new Padding(
					Math.Max( value.Left, 2 ),
					Math.Max( value.Top, 2 ),
					Math.Max( value.Right, 2 ),
					Math.Max( value.Bottom, 2 ) );
			}
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="PanelWithThemedBorder"/> class.
		/// </summary>
		public PanelWithThemedBorder()
		{
			this.Padding = new Padding( 2 );
		}
	}
}
