using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.IO;
using Microsoft.Win32;

namespace RcwInfo
{
    public partial class RcwInfoForm : Form
    {
        private static RegistryKey clsid = Registry.ClassesRoot.OpenSubKey("CLSID");

        public RcwInfoForm()
        {
            InitializeComponent();
            openToolStripButton_Click(this, null);
        }

        private void openToolStripButton_Click(object sender, EventArgs e)
        {
            if (openRcwFileDialog.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    Assembly rcwAssembly = Assembly.LoadFrom(openRcwFileDialog.FileName);
                    this.Text = Path.GetFileName(openRcwFileDialog.FileName);
                    rcwInfoGridView.Rows.Clear();
                    rcwInfoGridView.SuspendLayout();
                    Type[] types = rcwAssembly.GetTypes();
                    foreach (Type t in types)
                    {
                        if (t.IsCOMObject && t.IsClass)
                        {
                            string threadingModel = string.Empty;
                            RegistryKey keys = clsid.OpenSubKey(t.GUID.ToString("B"));
                            if (keys == null)
                            {
                                threadingModel = "Ist nicht registriert!";
                            }
                            else
                            {
                                keys = keys.OpenSubKey("InprocServer32");
                                if (keys == null)
                                {
                                    threadingModel = "Ist kein 'In-Process' Objekt!";
                                }
                                else
                                {
                                    threadingModel = (string)keys.GetValue("ThreadingModel");
                                    if (threadingModel != null)
                                    {
                                        switch (threadingModel.ToLower())
                                        {
                                            case "none":
                                                // Acording to some documentation this might be a possible value. 
                                                // On my system I found only missing "ThreadingModel" entrys for "None".
                                                threadingModel += " (Main STA)";
                                                break;
                                            case "apartment":
                                                threadingModel += " (STA)";
                                                break;
                                            case "free":
                                                threadingModel += " (MTA)";
                                                break;
                                            case "both":
                                            case "neutral":
                                                threadingModel += " (STA, MTA)";
                                                break;
                                        }
                                    }
                                    else
                                    {
                                        // No "ThreadingModel" entry.
                                        threadingModel = "None (Main STA)";
                                    }
                                }
                            }
                            rcwInfoGridView.Rows.Add(t.FullName, threadingModel);
                        }
                    }
                    rcwInfoGridView.ResumeLayout();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, ex.GetType().Name, MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }
    }
}