using System;
using System.Data.Sql;
using Microsoft.SqlServer.Server;
using System.Collections;
using System.Data.SqlTypes;
using System.Diagnostics;

public partial class UserDefinedFunctions
{
	[SqlFunction(
        FillRowMethodName = "FillEventRow", 
        TableDefinition = "timeWritten datetime, message nchar(4000), category nchar(400), instanceid bigint")
    ]
	public static IEnumerable EventLogAsTable(String logname)
	{
		return new EventLog(logname, Environment.MachineName).Entries;
	}

	public static void FillEventRow(Object obj, out SqlDateTime timeWritten, out SqlChars message, out SqlChars category, out long instanceId)
	{
		EventLogEntry eventLogEntry = (EventLogEntry)obj;
		timeWritten = new SqlDateTime(eventLogEntry.TimeWritten);
		message = new SqlChars(eventLogEntry.Message);
		category = new SqlChars(eventLogEntry.Category);
		instanceId = eventLogEntry.InstanceId;
	}
}

